/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

exports.__esModule = true;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var React = require('react');

var Loader = (function (_React$Component) {
    _inherits(Loader, _React$Component);

    function Loader() {
        _classCallCheck(this, Loader);

        _React$Component.apply(this, arguments);
    }

    Loader.prototype.svgSupport = function svgSupport() {
        return !!document.createElementNS && !!document.createElementNS('http://www.w3.org/2000/svg', 'svg').createSVGRect;
    };

    Loader.prototype.render = function render() {
        var ext = !this.svgSupport() ? 'gif' : 'svg';
        var style = Object.assign({ background: 'transparent', display: 'flex', alignItems: 'center', width: '100%', height: '100%' }, this.props.style || {});
        var src = window.pydio.Parameters.get('ajxpResourcesFolder') + '/themes/common/images/loader/hourglass.' + ext;
        return React.createElement(
            'div',
            { style: style },
            React.createElement(
                'div',
                { style: { background: 'transparent', flex: 1, textAlign: 'center' } },
                React.createElement('img', { src: src })
            )
        );
    };

    return Loader;
})(React.Component);

exports['default'] = Loader;
module.exports = exports['default'];
